function [iANZAHL_KNOTEN,aKNOTEN,aSTABELEMENTE,aKNOTENLASTEN,aLAGERBEDINGUNGEN,sDATEINAME] = Datensatz_Einlesen()
    %KONFIGURATION-------------------------------------------------------------------------------------------
    sSOLL(1)="Steuerdaten:";
    sSOLL(2)="Knoten:";
    sSOLL(3)="Stabelemente:";
    sSOLL(4)="Knotenlasten:";
    sSOLL(5)="Lagerbedingungen:";
    
    %FFNEN_DER_TEXTDATEI------------------------------------------------------------------------------------
	sDATEINAME = input('Geben Sie den Dateinamen mit den Steuerdaten ein (Dateityp: ".dat")\n','s');
    sDATEINAME = strcat(sDATEINAME,".dat");
	fhTEXTDATEI = fopen(sDATEINAME,'r');
    if (fhTEXTDATEI < 1)
		fprintf('%s konnte im Arbeitsverzeichnis nicht gefunden werden\nProgramm wird beendet\n',sDATEINAME);
		return;						
    else
 		fprintf('%s wurde geffnet\n',sDATEINAME);
        fprintf('//---------------------------------\n');
    end
    
    
    %EINLESEN_DER_STEUERDATEN--------------------------------------------------------------------------------
    %Steuerdaten
    frewind(fhTEXTDATEI);%Pointer zurcksetzen (beim ersten Mal unntig -> egal)
    sZEILE="";
    while(sZEILE~=sSOLL(1))
        sZEILE=fgetl(fhTEXTDATEI); 
        if(sZEILE==-1)
            fprintf('Formatierung in %s fehlerhaft!\n%s erwartet!\n',sDATEINAME,sSOLL(1));
            fprintf('//---------------------------------\n');
            return;
        end
    end
    for(i=1:1:3)%Weglesen der ***; Tabellenberschriften und ---,-----
        sZEILE=fgetl(fhTEXTDATEI);
    end
    aSPEICHER=fscanf(fhTEXTDATEI,'%u',4);
    aSTEUERDATEN(1,1:4)=aSPEICHER.';
    
    %Knoten
    frewind(fhTEXTDATEI);
    sZEILE="";
    while(sZEILE~=sSOLL(2))
        sZEILE=fgetl(fhTEXTDATEI); 
        if(sZEILE==-1)
            fprintf('Formatierung in %s fehlerhaft!\n%s erwartet!\n',sDATEINAME,sSOLL(2));
            fprintf('//---------------------------------\n');
            return;
        end
    end
    for(i=1:1:3)
        sZEILE=fgetl(fhTEXTDATEI);
    end
    i=1;
    while(1)
        iPOINTER=ftell(fhTEXTDATEI);
        sZEILE=fgetl(fhTEXTDATEI);
        iMERKER=0;
        for(j=1:1:size(sSOLL,2))
            if(sZEILE==sSOLL(j))
                iMERKER=1;
            end
        end
        if(iMERKER==1||strrep(strrep(sZEILE," ",""),"\t","")==""||sZEILE=="EOD")
            break;
        else
            fseek(fhTEXTDATEI,iPOINTER,'bof'); %Pointer zurcksetzen, weil ja Zeile zum Test schon eingelesen wurde
            aSPEICHER=fscanf(fhTEXTDATEI,'%f',3);
            aKNOTEN(i,1:3)=aSPEICHER.';
            fseek(fhTEXTDATEI,ftell(fhTEXTDATEI)+2,'bof'); %berlesen des Zeilenumbruchs
        end
        i=i+1;
    end
        
    %Stabelemente
    frewind(fhTEXTDATEI);
    sZEILE="";
    while(sZEILE~=sSOLL(3))
        sZEILE=fgetl(fhTEXTDATEI); 
        if(sZEILE==-1)
            fprintf('Formatierung in %s fehlerhaft!\n%s erwartet!\n',sDATEINAME,sSOLL(3));
            fprintf('//---------------------------------\n');
            return;
        end
    end
    for(i=1:1:3)
        sZEILE=fgetl(fhTEXTDATEI);
    end
    i=1;
    while(1)
        iPOINTER=ftell(fhTEXTDATEI);
        sZEILE=fgetl(fhTEXTDATEI);
        iMERKER=0;
        for(j=1:1:size(sSOLL,2))
            if(sZEILE==sSOLL(j))
                iMERKER=1;
            end
        end
        if(iMERKER==1||strrep(strrep(sZEILE," ",""),"\t","")==""||sZEILE=="EOD")
            break;
        else
            fseek(fhTEXTDATEI,iPOINTER,'bof');
            aSPEICHER=fscanf(fhTEXTDATEI,'%f',5);
            aSTABELEMENTE(i,1:5)=aSPEICHER.';
            fseek(fhTEXTDATEI,ftell(fhTEXTDATEI)+2,'bof');
        end
        i=i+1;
    end
    
    %Knotenlasten
    frewind(fhTEXTDATEI);
    sZEILE="";
    while(sZEILE~=sSOLL(4))
        sZEILE=fgetl(fhTEXTDATEI); 
        if(sZEILE==-1)
            fprintf('Formatierung in %s fehlerhaft!\n%s erwartet!\n',sDATEINAME,sSOLL(4));
            fprintf('//---------------------------------\n');
            return;
        end
    end
    for(i=1:1:3)
        sZEILE=fgetl(fhTEXTDATEI);
    end
    i=1;
    while(1)
        iPOINTER=ftell(fhTEXTDATEI);
        sZEILE=fgetl(fhTEXTDATEI);
        iMERKER=0;
        for(j=1:1:size(sSOLL,2))
            if(sZEILE==sSOLL(j))
                iMERKER=1;
            end
        end
        if(iMERKER==1||strrep(strrep(sZEILE," ",""),"\t","")==""||sZEILE=="EOD")
            break;
        else
            fseek(fhTEXTDATEI,iPOINTER,'bof');
            aSPEICHER=fscanf(fhTEXTDATEI,'%f',3);
            aKNOTENLASTEN(i,1:3)=aSPEICHER.';
            fseek(fhTEXTDATEI,ftell(fhTEXTDATEI)+2,'bof');
        end
        i=i+1;
    end
    
    %Lagerbedingungen
    frewind(fhTEXTDATEI);
    sZEILE="";
    while(sZEILE~=sSOLL(5))
        sZEILE=fgetl(fhTEXTDATEI); 
        if(sZEILE==-1)
            fprintf('Formatierung in %s fehlerhaft!\n%s erwartet!\n',sDATEINAME,sSOLL(5));
            fprintf('//---------------------------------\n');
            return;
        end
    end
    for(i=1:1:3)
        sZEILE=fgetl(fhTEXTDATEI);
    end
        i=1;
    while(1)
        iPOINTER=ftell(fhTEXTDATEI);
        sZEILE=fgetl(fhTEXTDATEI);
        iMERKER=0;
        for(j=1:1:size(sSOLL,2))
            if(sZEILE==sSOLL(j))
                iMERKER=1;
            end
        end
        if(iMERKER==1||strrep(strrep(sZEILE," ",""),"\t","")==""||sZEILE=="EOD")
            break;
        else
            fseek(fhTEXTDATEI,iPOINTER,'bof');
            aSPEICHER=fscanf(fhTEXTDATEI,'%f',3);
            aLAGERBEDINGUNGEN(i,1:3)=aSPEICHER.';
            fseek(fhTEXTDATEI,ftell(fhTEXTDATEI)+2,'bof');
        end
        i=i+1;
    end
    
    %SCHLIEEN_DER_TEXTDATEI---------------------------------------------------------------------------------
    fclose(fhTEXTDATEI);
    
    %AUFSTEIGENDE_SORTIERUNG_DER_TABELLEN_NACH_1.SPALTE------------------------------------------------------
    aKNOTEN=sortrows(aKNOTEN);
    aSTABELEMENTE=sortrows(aSTABELEMENTE);
    aKNOTENLASTEN=sortrows(aKNOTENLASTEN);
    aLAGERBEDINGUNGEN=sortrows(aLAGERBEDINGUNGEN);
    
    %PRFUNG_DER_EINGELESENEN_DATEN--------------------------------------------------------------------------
    %Initialisierung
    iANZAHL_KNOTEN=size(aKNOTEN,1);
	iANZAHL_STAEBE=size(aSTABELEMENTE,1);
    iANZAHL_LASTEN=size(aKNOTENLASTEN,1);
	iANZAHL_RANDBEDINGUNGEN=size(aLAGERBEDINGUNGEN,1);
    aSTEUERDATEN_IST(:)=[iANZAHL_KNOTEN,iANZAHL_STAEBE,iANZAHL_LASTEN,iANZAHL_RANDBEDINGUNGEN];
    sWARNUNG="Scotty, wir haben ein Problem mit den ";
    %Prfung
    for(i=1:1:size(aSTEUERDATEN_IST,1))
        if(aSTEUERDATEN_IST(i)<aSTEUERDATEN(i))
            fprintf('%s%s!\n',sWARNUNG,sSOLL(i+1));
            fprintf('Es gibt zu wenig Zeileneintrge (%u) unter der berschrift "%s"\n',aSTEUERDATEN_IST(i),sSOLL(1+1));
            fprintf('Laut "%s" (%u) erwartet!',sSOLL(1),aSTEUERDATEN(i));
            fprintf('Korrigieren Sie die Datei "%s" und starten Sie das Programm erneut!\n',sDATEINAME);
            return;
        elseif(aSTEUERDATEN_IST(1)>aSTEUERDATEN(1))
            fprintf('%s%s!\n',sWARNUNG,sSOLL(i+1));
            fprintf('Es gibt zu viele Zeileneintrge (%u) unter der berschrift "%s"\n',aSTEUERDATEN_IST(i),sSOLL(1+1));
            fprintf('Laut "%s" (%u) erwartet!\n',sSOLL(1),aSTEUERDATEN(i));
            fprintf('Korrigieren Sie die Datei "%s" und starten Sie das Programm erneut!\n',sDATEINAME);
            return;
        end
    end
end

